<?php

header('Content-Type: application/json');

include 'db.php';

$user_id = $_GET['user_id'] ?? null;

if (!$user_id) {
    echo json_encode(["status" => "error", "message" => "User ID is required"]);
    exit;
}

// Escape user_id to prevent SQL injection
$user_id = mysqli_real_escape_string($conn, $user_id);

$response = [
    "status" => "error",
    "message" => "No invoices found for this user"
];

// Query to get all invoices for the user
$invoices_query = "
  SELECT 
    o.invoice_no,
    o.Created_date,
    o.invoice_id,
    o.Grand_total,
    o.Action_status,
    o.Payment_status
  FROM 
    invoice o
  WHERE 
    o.Delete_status = 0 AND o.user_id = '$user_id'
  GROUP BY 
    o.invoice_id
  ORDER BY 
    o.Created_date DESC;
";

$invoices_result = mysqli_query($conn, $invoices_query);

if ($invoices_result && mysqli_num_rows($invoices_result) > 0) {
    $invoices = [];
    
    while ($invoice = mysqli_fetch_assoc($invoices_result)) {
        $invoice_id = $invoice['invoice_id'];
        
        // Get invoice items with product details
        $invoice_data_query = "
            SELECT 
                od.Product_id,
                od.qty,
                od.Product_total,
                p.Product_name,
                p.Product_image
            FROM 
                invoice_data od
            LEFT JOIN
                product p ON od.Product_id = p.Product_id
            WHERE 
                od.invoice_id = '$invoice_id' AND od.Delete_status = 0
        ";
        $invoice_data_result = mysqli_query($conn, $invoice_data_query);
        
        $invoice_items = [];
        if ($invoice_data_result && mysqli_num_rows($invoice_data_result) > 0) {
            while ($item = mysqli_fetch_assoc($invoice_data_result)) {
                $invoice_items[] = [
                    'product_id' => $item['Product_id'],
                    'quantity' => $item['qty'],
                    'product_total' => $item['Product_total'],
                    'product_name' => $item['Product_name'],
                    'product_image' => $item['Product_image']
                ];
            }
        }
        
        $invoices[] = [
            'invoice_no' => $invoice['invoice_no'],
            'invoice_id' => $invoice['invoice_id'],
            'invoice_date' => $invoice['Created_date'],
            'action' => $invoice['Action_status'],
            'payment' => $invoice['Payment_status'],
            'total' => $invoice['Grand_total'],
            'products' => $invoice_items
        ];
    }
    
    $response = [
        "status" => "success",
        "message" => "Invoices fetched successfully",
        "data" => $invoices
    ];
}

echo json_encode($response);

// Close database connection
mysqli_close($conn);
?>